{
This file Copyright 2000 (c) CDF, Inc.
Written By: Edward Flick (Directrix1@yahoo.com)
Use at your own risk!
}

unit DataMover;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs, db, ExpressionEval;

//A Class to move data from one dataset into another, like BatchMove but works
//with any dataset and is only an appending class, also can be used to update a
//table from itself when Source and Destination point to the same object.
type
  TDataMover = class(TExpressionEval)
  protected
    { Protected declarations }
    FDestination: TDataset;
    FSrcExpr: TStrings;
    FDestFields: TStrings;
    FErrors: TStrings;
    procedure setSrcExpr(ti: TStrings);
    procedure setDestFields(ti: TStrings);
    procedure setErrors(ti: TStrings);
    //Custom Functions
    function CSrcRecno(ins: array of String): String;
    function CSrcReccount(ins: array of String): String;
    function CDstRecno(ins: array of String): String;
    function CDstReccount(ins: array of String): String;
  public
    { Public declarations }
    procedure transfer; virtual;
    constructor create(Owner: TComponent); override;
    destructor destroy; override;
  published
    { Published declarations }
    property Destination: TDataset read FDestination write FDestination;
    property SrcExpressions: TStrings read FSrcExpr write setSrcExpr;
    property DestFields: TStrings read FDestFields write setDestFields;
    property Errors: TStrings read FErrors write setErrors;
  end;

procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('Data Access', [TDataMover]);
end;

//Transfer data from Source to Destination, Datasets must already be active
//and Destination should be modifiable
procedure TDataMover.transfer;
var
  j,k: integer;
begin
FSource.First;
if FSrcExpr.count<>FDestFields.count then   //Verify one-to-one mapping
  raise Exception.create('There must be a one-to-one mapping between SourceExpressions and DestinationFields');
FErrors.Clear;
k:=1;
while not source.eof do                   //Iterate through all records in Source
  begin
  if FSource<>FDestination then           //check if this is an update or import
    FDestination.Append                   //and append the listed expressions evaluated
  else
    FDestination.Edit;                    //or just update from the listed expression evaluated
  for j:=0 to FSrcExpr.count - 1 do       //to the listed fields, simple.
    if FSrcExpr[j]<>'' then
      FDestination.FieldByName(FDestFields[j]).asString:=evaluate(FSrcExpr[j]);
  try
    FDestination.Post;                    //try to make changes solid
  except
    try
      FDestination.Cancel;                //no can do, so back out
    except
      end;
    FErrors.Add(inttostr(k));             //log this record num for posterity
    end;
  FSource.Next;                           //Move on
  inc(k);
  end;
end;

constructor TDataMover.create(Owner: TComponent);
begin
inherited create(owner);
FSrcExpr:=TStringList.Create();
FDestFields:=TStringList.Create();
FErrors:=TStringList.Create();
registerFunction('SRC.RECNO',CSrcRecno);
registerFunction('SRC.RECCOUNT',CSrcReccount);
registerFunction('DST.RECNO',CDstRecno);
registerFunction('DST.RECCOUNT',CDstReccount);
registerFunction('RECNO',CDstRecno);
registerFunction('RECCOUNT',CDstReccount);
end;

destructor TDataMover.destroy;
begin
FSrcExpr.free;
FDestFields.free;
FErrors.free;
inherited destroy;
end;

procedure TDataMover.setSrcExpr(ti: TStrings);
begin
FSrcExpr.Assign(ti);
end;

procedure TDataMover.setDestFields(ti: TStrings);
begin
FDestFields.Assign(ti);
end;

procedure TDataMover.setErrors(ti: TStrings);
begin
//Do nothing READ-ONLY
end;

//Custom Table Functions
function TDataMover.CSrcRecno(ins: array of String): String;
begin
  result:=inttostr(FSource.RecNo);
end;

function TDataMover.CSrcReccount(ins: array of String): String;
begin
  result:=inttostr(FSource.RecordCount);
end;

function TDataMover.CDstRecno(ins: array of String): String;
begin
  result:=inttostr(FDestination.RecNo);
end;

function TDataMover.CDstReccount(ins: array of String): String;
begin
  result:=inttostr(FDestination.RecordCount);
end;

end.
